
#include <setjmp.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdint.h>
//#define JPEG_INTERNALS

#include "jerror.h"
#include	"drawjpeg.h"
#include	"jpeglib.h"
#include    "jexif.h"

/* Global Version Information */
const unsigned char g_SVGBDJ_version[] = "$Name: SVG_r2_C02 $";


/* 2001.05.17 changed by M.Kozawa - ST - */
//#ifdef _MIPS	/* _MIPS CORE1 */
//#pragma ghs section data   = default	/* JPG ZNVI */
//#pragma ghs section bss    = default	/* JPG ZNVI */
//#pragma ghs section rodata = default	/* JPG ZNVI */
//#else	/* _MIPS CORE1 */
//#pragma section
//#endif	/* _MIPS CORE1 */
/* 2001.05.17 changed by M.Kozawa - ED - */


typedef struct _jpeg_dec_info{
	int     r_up,r_down;
	int     g_up,g_down;
	int     b_up,b_down;

	int     img_start_x;
	int     img_end_x;
	int     img_start_y;
	int     img_end_y;

	int     pixaddr_slow;

	int     zx,zy;

	int     endline;
	int     finishline;

	int 	bufferinc0;
	int 	pixaddrinc0;
	unsigned char  *buffer0;

	int 	Orientation;
	int     r_index;
	int     b_index;

}jpeg_decoding_info;

extern void gjpeg_exif_init(j_decompress_ptr cinfo);

void (*_PutScanline)(jpeg_decoding_info *jpeg_dec_info);

#define CLEAN_UP_FILE(x)   {if (x) fclose(x);}

struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */

  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;



/*
* Here's the routine that will replace the standard error_exit method:
*/
METHODDEF(void) my_error_exit (j_common_ptr cinfo)
{
    /* cinfo->err really points to a my_error_mgr struct, so coerce pointer */
    my_error_ptr myerr = (my_error_ptr) cinfo->err;

    /* Always display the message. */
    /* We could postpone this until after returning, if we chose. */
/*    (*cinfo->err->output_message) (cinfo);*/

    /* Return control to the setjmp point */
    longjmp(myerr->setjmp_buffer, 1);
}


int Init_Blit_Variable (BIT_POS *def, int *up, int *down)
{
    int bits=def->bit_e+1-def->bit_s;

    if (bits<0)
        return 0;

    if (bits<8)
        *down=8-bits;
    else
        *down=0;

    if (def->bit_e+1>8-*down)
        *up=def->bit_e+1+(-8+*down);
    else
        *up=0;

    return 1;
}


void _PutScanline_8bit_color( jpeg_decoding_info *jpeg_dec_info)
{
    register unsigned char     *buffer;
    unsigned char			   *buffer0_local;
    register unsigned long      pixel;
    register int    pixaddr;
    register int    bufferinc;
    int    	pixaddrinc;
    int    	x,endx;
    int    	opzx;
    int 	r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
    int 	g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
    int 	b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;
    int     r_index =jpeg_dec_info->r_index, b_index = jpeg_dec_info->b_index;

    bufferinc = jpeg_dec_info->bufferinc0;
    buffer = buffer0_local = jpeg_dec_info->buffer0;
    pixaddr = jpeg_dec_info->pixaddr_slow;
    pixaddrinc = jpeg_dec_info->pixaddrinc0;
    opzx=(1024*1024)/jpeg_dec_info->zx;
    endx=jpeg_dec_info->img_end_x*opzx;
    for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=((buffer[r_index]>>r_down)<<r_up)|((buffer[1]>>g_down)<<g_up)|((buffer[b_index]>>b_down)<<b_up);

        #ifdef VRAM_OTHER_ENDIAN
        *(unsigned char*)(pixaddr^3)=pixel;
#else
        *(unsigned char*)(uintptr_t)(pixaddr)=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}
void _PutScanline_16bit_color( jpeg_decoding_info *jpeg_dec_info)
{
    register unsigned char     *buffer;
    unsigned char			   *buffer0_local;
    register unsigned long      pixel;
    register int    pixaddr;
    register int    bufferinc;
    int    	pixaddrinc;
    int    	x,endx;
    int    	opzx;
    int 	r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
    int 	g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
    int 	b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;
    int     r_index =jpeg_dec_info->r_index, b_index = jpeg_dec_info->b_index;
    bufferinc = jpeg_dec_info->bufferinc0;
    buffer = buffer0_local = jpeg_dec_info->buffer0;
    pixaddr = jpeg_dec_info->pixaddr_slow;
    pixaddrinc = jpeg_dec_info->pixaddrinc0;

    opzx=(1024*1024)/jpeg_dec_info->zx;
    endx=jpeg_dec_info->img_end_x*opzx;

    for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=((buffer[r_index]>>r_down)<<r_up)|((buffer[1]>>g_down)<<g_up)|((buffer[b_index]>>b_down)<<b_up);
#if defined(FMU5)
		pixel |= 0x0020;
#endif
#ifdef VRAM_OTHER_ENDIAN
        *(unsigned short*)(pixaddr^2)=pixel;
#else
        *(unsigned short*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}
void _PutScanline_24bit_color(jpeg_decoding_info *jpeg_dec_info)
{
    register unsigned char     *buffer;
    unsigned char			   *buffer0_local;
    register unsigned long      pixel;
    register int    pixaddr;
    register int    bufferinc;
    int    	pixaddrinc;
    int    	x,endx;
    int    	opzx;
    int 	r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
    int 	g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
    int 	b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;
    int     r_index =jpeg_dec_info->r_index, b_index = jpeg_dec_info->b_index;

    bufferinc = jpeg_dec_info->bufferinc0;
    buffer = buffer0_local = jpeg_dec_info->buffer0;
    pixaddr = jpeg_dec_info->pixaddr_slow;
    pixaddrinc = jpeg_dec_info->pixaddrinc0;

    opzx=(1024*1024)/jpeg_dec_info->zx;
    endx=jpeg_dec_info->img_end_x*opzx;

    for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=((buffer[r_index]>>r_down)<<r_up)|((buffer[1]>>g_down)<<g_up)|((buffer[b_index]>>b_down)<<b_up);

#ifdef VRAM_OTHER_ENDIAN
        *(unsigned char*)((pixaddr+0)^3)=((unsigned char*)(&pixel))[0];
        *(unsigned char*)((pixaddr+1)^3)=((unsigned char*)(&pixel))[1];
        *(unsigned char*)((pixaddr+2)^3)=((unsigned char*)(&pixel))[2];
#else
        *(unsigned long*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}


void _PutScanline_32bit_color(jpeg_decoding_info *jpeg_dec_info)
{
    register unsigned char     *buffer;
    unsigned char			   *buffer0_local;
    register unsigned long      pixel;
    register int    pixaddr;
    register int    bufferinc;
    int    	pixaddrinc;
    int    	x,endx;
    int    	opzx;
    int 	r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
    int 	g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
    int 	b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;
    int     r_index =jpeg_dec_info->r_index, b_index = jpeg_dec_info->b_index;

    bufferinc = jpeg_dec_info->bufferinc0;
    buffer = buffer0_local = jpeg_dec_info->buffer0;
    pixaddr = jpeg_dec_info->pixaddr_slow;
    pixaddrinc = jpeg_dec_info->pixaddrinc0;

    opzx=(1024*1024)/jpeg_dec_info->zx;
    endx=jpeg_dec_info->img_end_x*opzx;
    for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=(JPEG_ALPHA_DEFAULT_ARGB8888) |   /* tkniep: added alpha value for gen2 */
              ((buffer[r_index]>>r_down)<<r_up)  |
              ((buffer[1]>>g_down)<<g_up)  |
              ((buffer[b_index]>>b_down)<<b_up);
#ifdef VRAM_OTHER_ENDIAN
/*
        *(unsigned char*)((pixaddr+0)^3)=((unsigned char*)(&pixel))[0];
        *(unsigned char*)((pixaddr+1)^3)=((unsigned char*)(&pixel))[1];
        *(unsigned char*)((pixaddr+2)^3)=((unsigned char*)(&pixel))[2];
        *(unsigned char*)((pixaddr+3)^3)=((unsigned char*)(&pixel))[3];
*/
        *(unsigned long*)pixaddr= (pixel<<24) | ((pixel <<8) & 0xff0000) | ((pixel >>8) & 0xff00) | ((pixel >>24) & 0xff);
#else
        *(unsigned long*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}

void _PutScanline_8bit_grayscale(jpeg_decoding_info *jpeg_dec_info)
{
	register unsigned char *buffer;
	unsigned char *buffer0_local;
	register unsigned long pixel;
	register int pixaddr;
	register int bufferinc;
	int pixaddrinc;
	int x, endx;
	int opzx;
	int r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
	int g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
	int b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;

	bufferinc = jpeg_dec_info->bufferinc0;
	buffer = buffer0_local = jpeg_dec_info->buffer0;
	pixaddr = jpeg_dec_info->pixaddr_slow;
	pixaddrinc = jpeg_dec_info->pixaddrinc0;

	opzx = (1024 * 1024) / jpeg_dec_info->zx;
	endx = jpeg_dec_info->img_end_x * opzx;

	for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=buffer[0];
        pixel=((pixel>>r_down)<<r_up)|((pixel>>g_down)<<g_up)|((pixel>>b_down)<<b_up);
#ifdef VRAM_OTHER_ENDIAN
        *(unsigned char*)(pixaddr^3)=pixel;
#else
        *(unsigned char*)(uintptr_t)(pixaddr)=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}
void _PutScanline_16bit_grayscale(jpeg_decoding_info *jpeg_dec_info)
{
	register unsigned char *buffer;
	unsigned char *buffer0_local;
	register unsigned long pixel;
	register int pixaddr;
	register int bufferinc;
	int pixaddrinc;
	int x, endx;
	int opzx;
	int r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
	int g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
	int b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;

	bufferinc = jpeg_dec_info->bufferinc0;
	buffer = buffer0_local = jpeg_dec_info->buffer0;
	pixaddr = jpeg_dec_info->pixaddr_slow;
	pixaddrinc = jpeg_dec_info->pixaddrinc0;

	opzx = (1024 * 1024) / jpeg_dec_info->zx;
	endx = jpeg_dec_info->img_end_x * opzx;

	for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=buffer[0];
        pixel=((pixel>>r_down)<<r_up)|((pixel>>g_down)<<g_up)|((pixel>>b_down)<<b_up);
#if defined(FMU5)
		pixel |= 0x0020;
#endif
#ifdef VRAM_OTHER_ENDIAN
/*
        *(unsigned char*)(pixaddr^3)=((unsigned char*)(&pixel))[0];
        *(unsigned char*)((pixaddr+1)^3)=((unsigned char*)(&pixel))[1];
*/
        *(unsigned short*)(pixaddr^2)= (pixel<<8) | ((pixel >>8) & 0xff);
#else
        *(unsigned short*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}
void _PutScanline_24bit_grayscale(jpeg_decoding_info *jpeg_dec_info)
{
	register unsigned char *buffer;
	unsigned char *buffer0_local;
	register unsigned long pixel;
	register int pixaddr;
	register int bufferinc;
	int pixaddrinc;
	int x, endx;
	int opzx;
	int r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
	int g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
	int b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;

	bufferinc = jpeg_dec_info->bufferinc0;
	buffer = buffer0_local = jpeg_dec_info->buffer0;
	pixaddr = jpeg_dec_info->pixaddr_slow;
	pixaddrinc = jpeg_dec_info->pixaddrinc0;

	opzx = (1024 * 1024) / jpeg_dec_info->zx;
	endx = jpeg_dec_info->img_end_x * opzx;

	for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=buffer[0];
        pixel=((pixel>>r_down)<<r_up)|((pixel>>g_down)<<g_up)|((pixel>>b_down)<<b_up);
#ifdef VRAM_OTHER_ENDIAN
        *(unsigned char*)((pixaddr+0)^3)=((unsigned char*)(&pixel))[0];
        *(unsigned char*)((pixaddr+1)^3)=((unsigned char*)(&pixel))[1];
        *(unsigned char*)((pixaddr+2)^3)=((unsigned char*)(&pixel))[2];
#else
        *(unsigned long*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}

void _PutScanline_32bit_grayscale(jpeg_decoding_info *jpeg_dec_info)
{
	register unsigned char *buffer;
	unsigned char *buffer0_local;
	register unsigned long pixel;
	register int pixaddr;
	register int bufferinc;
	int pixaddrinc;
	int x, endx;
	int opzx;
	int r_down = jpeg_dec_info->r_down, r_up = jpeg_dec_info->r_up;
	int g_down = jpeg_dec_info->g_down, g_up = jpeg_dec_info->g_up;
	int b_down = jpeg_dec_info->b_down, b_up = jpeg_dec_info->b_up;
    int     r_index =jpeg_dec_info->r_index, b_index = jpeg_dec_info->b_index;

	bufferinc = jpeg_dec_info->bufferinc0;
	buffer = buffer0_local = jpeg_dec_info->buffer0;
	pixaddr = jpeg_dec_info->pixaddr_slow;
	pixaddrinc = jpeg_dec_info->pixaddrinc0;

	opzx = (1024 * 1024) / jpeg_dec_info->zx;
	endx = jpeg_dec_info->img_end_x * opzx;

	for(x=0;x<endx;x+=opzx)
        {
        buffer=buffer0_local+((x)>>10)*bufferinc;
        pixel=(JPEG_ALPHA_DEFAULT_ARGB8888) |   /* efriedrich: added alpha value for gen2 */
                   ((buffer[r_index]>>r_down)<<r_up)  |
                   ((buffer[1]>>g_down)<<g_up)  |
                   ((buffer[b_index]>>b_down)<<b_up);
#ifdef VRAM_OTHER_ENDIAN
/*
        *(unsigned char*)((pixaddr+0)^3)=((unsigned char*)(&pixel))[0];
        *(unsigned char*)((pixaddr+1)^3)=((unsigned char*)(&pixel))[1];
        *(unsigned char*)((pixaddr+2)^3)=((unsigned char*)(&pixel))[2];
        *(unsigned char*)((pixaddr+3)^3)=((unsigned char*)(&pixel))[3];
*/
        *(unsigned long*)pixaddr= (pixel<<24) | ((pixel <<8) & 0xff0000) | ((pixel >>8) & 0xff00) | ((pixel >>24) & 0xff);
#else
        *(unsigned long*)(uintptr_t)pixaddr=pixel;
#endif
        pixaddr+=pixaddrinc;
        }
}

void PutImageSlice(DRAW_AREA_INFO  *draw_area,
					struct jpeg_decompress_struct *cInfo,
					jpeg_decoding_info *jpeg_dec_info,
					int *stop_flag)
{
    int     lineno;
    int     lineinc;
    int     opzy,bw;
    int		scanline_size;

    JSAMPARRAY scanline_buffer;        /* Output row buffer */

    lineno=0;
    bw=-512;
    opzy=(1024*1024)/jpeg_dec_info->zy;

    jpeg_dec_info->pixaddr_slow=((int)(uintptr_t)draw_area->vram_adrs);
    switch(jpeg_dec_info->Orientation)
        {
        case 3:
        	jpeg_dec_info->pixaddrinc0 = -draw_area->rgb.size;
        	jpeg_dec_info->pixaddr_slow -= jpeg_dec_info->pixaddrinc0*(jpeg_dec_info->img_end_x-1);
        	lineinc=-draw_area->mwidth;
        	jpeg_dec_info->pixaddr_slow -= lineinc*(jpeg_dec_info->img_end_y-1);
            break;
        case 6:
        	jpeg_dec_info->pixaddrinc0=draw_area->mwidth;
            lineinc=-draw_area->rgb.size;
            jpeg_dec_info->pixaddr_slow+=draw_area->rgb.size*(jpeg_dec_info->img_end_y-1);
            break;
        case 8:
        	jpeg_dec_info->pixaddrinc0=-draw_area->mwidth;
            lineinc=draw_area->rgb.size;
            jpeg_dec_info->pixaddr_slow+=draw_area->mwidth*(jpeg_dec_info->img_end_x-1);
            break;
        default:
        	jpeg_dec_info->pixaddrinc0=draw_area->rgb.size;
            lineinc=draw_area->mwidth;
            break;
        }
    /* We may need to do some setup of our own at this point before reading
	 * the data.  After gjpeg_calc_output_dimensions() we have the correct scaled
	 * output image dimensions available.*/
	/* JSAMPLEs per row in output buffer */
	scanline_size = cInfo->output_width * cInfo->output_components;
	/* Make a one-row-high sample array that will go away when done with image */
	scanline_buffer = (*cInfo->mem->alloc_sarray)((j_common_ptr) cInfo,
			JPOOL_IMAGE, scanline_size, 1);

	jpeg_dec_info->buffer0 = scanline_buffer[0] + cInfo->output_components * jpeg_dec_info->img_start_x;

    while (cInfo->output_scanline <= cInfo->output_height)
    {
        bw+=opzy;
        while ( bw >= 0 )
        {
				bw-=1024;
				jpeg_read_scanlines(cInfo, scanline_buffer, 1);
        }

        if (*stop_flag)
            return;

        if (cInfo->output_scanline > (unsigned int)jpeg_dec_info->img_start_y)
        {
            _PutScanline(jpeg_dec_info);

            jpeg_dec_info->pixaddr_slow+=lineinc;
            lineno++;

            if(lineno >= jpeg_dec_info->img_end_y)
            {
                cInfo->output_scanline = cInfo->output_height;//make jpeglib think we have read all data
            	return;
            }
        }
    }
}

U4  _PutImageJPEG (DRAW_AREA_INFO  *draw_area,DRAW_IMG_INFO   *draw_img, int *stop_flag)
{
	/* We use our private extension JPEG error handler.
	    * Note that this struct must live as long as the main JPEG parameter
	    * struct, to avoid dangling-pointer problems.
	    */
	    struct my_error_mgr jerr;
	    /* More stuff */

	    /* This struct contains the JPEG decompression parameters and pointers to
	    * working space (which is allocated as needed by the JPEG library).
	    */
	    jpeg_decompress_struct_ext 	cInfo;
	    jpeg_decoding_info 				jpeg_dec_info;

	    FILE    *inputfile = NULL;
	    int     picx,picy;
		int 	z;				/*jpeg pre-scaling factor*/
		int 	tmp;
		float 	yz,xz;

	    /* allocate and initialize JPEG decompression object */
	    /* We set up the normal JPEG error routines, then override error_exit. */
	    cInfo.cInfo.err = jpeg_std_error(&jerr.pub);
	    jerr.pub.error_exit = my_error_exit;
	    /* Establish the setjmp return context for my_error_exit to use. */
	    if (setjmp(jerr.setjmp_buffer)) {
	        /* If we get here, the JPEG code has signaled an error.
	        * We need to clean up the JPEG object, close the input file, and return.
	        */
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        //CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	    }

	    if (draw_img->org.x<0 || draw_img->org.y<0)
	        return JPEG_FAILURE;

	    if (draw_img->type & FILE_IMG)
        {
		    inputfile=fopen((char*)draw_img->datap,"rb");

		    if (inputfile==NULL)
		        return JPEG_FAILURE;
        }
	    else
        {
		    inputfile=NULL;
        }


		/*  */
/* based on jeffect ->jpeg_tone_effect   seems to be only in ADIT implementation */
/*	    jpeg_set_picture_effect(draw_img->image_effect.tone_effect.effect_enable,
								 draw_img->image_effect.tone_effect.V,
								 draw_img->image_effect.tone_effect.U);
*/
	    jpeg_create_decompress((struct jpeg_decompress_struct*)&cInfo);
	    gjpeg_exif_init((struct jpeg_decompress_struct*)&cInfo);
	    jpeg_mem_src((struct jpeg_decompress_struct*)&cInfo, draw_img->datap, draw_img->datasize);
	    jpeg_read_header((struct jpeg_decompress_struct*)&cInfo, TRUE);

	    /* main image or thumbnail? */
	    if (draw_img->type & IMG_TYP_THNMB)
	        {
	        if ((cInfo.EXIF_Info.SawWhat &
	               ((EXIF_SAW_COMPRESSION | EXIF_SAW_JPEGIFOFFSET | EXIF_SAW_JPEGIFBYTECOUNT | EXIF_SAW_ERROR)))!=
	                (EXIF_SAW_COMPRESSION | EXIF_SAW_JPEGIFOFFSET | EXIF_SAW_JPEGIFBYTECOUNT))
	            ERREXIT((struct jpeg_decompress_struct*)&cInfo,0);

	        if (cInfo.EXIF_Info.Compression!=6)
	            ERREXIT((struct jpeg_decompress_struct*)&cInfo,0);

	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);

	        jpeg_create_decompress((struct jpeg_decompress_struct*)&cInfo);
	        //jpeg_stdio_src(&cInfo,draw_img->type,draw_img->datap,draw_img->datasize,inputfile,EXIF_Info.App1Offset+EXIF_Info.JpegIFOffset,EXIF_Info.JpegIFByteCount);
	        jpeg_mem_src( (struct jpeg_decompress_struct*)&cInfo, draw_img->datap, draw_img->datasize);
	        jpeg_read_header((struct jpeg_decompress_struct*)&cInfo, TRUE);
	        }

	    /* set parameters for decompression */
	    cInfo.cInfo.do_fancy_upsampling=FALSE;
	    cInfo.cInfo.dct_method=PREFERRED_DCT_METHOD;

		/*calculate the pre-scaling factor for jpeglib (speed improvement)*/
		yz = (int)(draw_img->size.y / draw_area->size.y);
		xz = (int)(draw_img->size.x / draw_area->size.x);
		if(yz > xz)
			z = (int)yz;
		else
			z = (int)xz;

		if( z < 2)
			z = 1;
		else if(z < 4)
			z = 2;
		else if(z < 8)
			z = 4;
		else
			z = 8;

		cInfo.cInfo.scale_num = 1;
		cInfo.cInfo.scale_denom = z;
		draw_img->zx *= cInfo.cInfo.scale_denom;
		draw_img->zy = draw_img->zx;

	    jpeg_calc_output_dimensions((struct jpeg_decompress_struct*)&cInfo);
    	jpeg_dec_info.r_index = 2;
    	jpeg_dec_info.b_index = 0;
	    if(draw_img->revert > 0)
	    {
	    	jpeg_dec_info.r_index = 0;
	    	jpeg_dec_info.b_index = 2;
	    }

	    /* Initialize the blitting variables */
	    if(!Init_Blit_Variable(&draw_area->rgb.r,&jpeg_dec_info.r_up,&jpeg_dec_info.r_down))
	        {
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	        }
	    if(!Init_Blit_Variable(&draw_area->rgb.g,&jpeg_dec_info.g_up,&jpeg_dec_info.g_down))
	        {
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	        }
	    if(!Init_Blit_Variable(&draw_area->rgb.b,&jpeg_dec_info.b_up,&jpeg_dec_info.b_down))
	        {
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	        }

		jpeg_dec_info.Orientation = draw_img->image_effect.rotation;

		if(jpeg_dec_info.Orientation == 6 || jpeg_dec_info.Orientation == 8)
		{
			tmp = draw_area->size.x;
			draw_area->size.x = draw_area->size.y;
			draw_area->size.y = (I2)tmp;
		}

	    /*-----------------7/31/01 12:18PM------------------
	     * defx
	     * --------------------------------------------------*/
	    jpeg_dec_info.zx=(((cInfo.cInfo.output_width*draw_img->zx)/1024)*1024) / cInfo.cInfo.output_width;
	       /* start coordinates */
	       jpeg_dec_info.img_start_x = draw_img->org.x / z ;
	       /* drawing size */
	       jpeg_dec_info.img_end_x=draw_area->size.x;
	       /* available pixels in picture */
	       picx= cInfo.cInfo.output_width - jpeg_dec_info.img_start_x;
	      //eufr if (picx > draw_img->size.x)
	      //eufr   picx = draw_img->size.x;
	       /* available transformed pixels in picture */
	       picx=( picx*jpeg_dec_info.zx + 512 )/1024;
	       /* are there enough pixels? */
	       if (jpeg_dec_info.img_end_x > picx)
	    	  jpeg_dec_info.img_end_x = picx;
	       jpeg_dec_info.img_end_x=jpeg_dec_info.img_end_x;

	       /*-----------------7/31/01 12:18PM------------------
	        * defy
	        * --------------------------------------------------*/
	       jpeg_dec_info.zy=(((cInfo.cInfo.output_height*draw_img->zy)/1024)*1024) / cInfo.cInfo.output_height;
	       /* start coordinates */
	       jpeg_dec_info.img_start_y=draw_img->org.y / z ;
	       /* drawing size */
	       if (draw_area->mwidth < 0)
	       	jpeg_dec_info.img_end_y=-draw_area->size.y;
	       else
	       	jpeg_dec_info.img_end_y=draw_area->size.y;
	       /* available pixels in picture */
	       picy= cInfo.cInfo.output_height - jpeg_dec_info.img_start_y;
	       //eufr if (picy>draw_img->size.y)
	       //eufr    picy=draw_img->size.y;
	       /* available transformed pixels in picture */
	       picy=(picy*jpeg_dec_info.zy+512)/1024;
	       /* are there enough pixels? */
	       if (jpeg_dec_info.img_end_y > picy)
	       	  jpeg_dec_info.img_end_y = picy;
	       jpeg_dec_info.img_end_y=jpeg_dec_info.img_end_y;
	    /* quick tests */
	    if (picx<0 || picy<0)
	        {
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	        }

	    if (jpeg_dec_info.img_start_x<0 || jpeg_dec_info.img_start_y<0 ||
	    	  jpeg_dec_info.img_end_x<0 || jpeg_dec_info.img_end_y<0)
	        {
	        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	        CLEAN_UP_FILE(inputfile);
	        return JPEG_FAILURE;
	        }
	    /* Set scanline renderer */
	    switch (cInfo.cInfo.output_components)
	        {
	        case 1:
	            switch (draw_area->rgb.size)
	                    {
	                    case 1:
	                        _PutScanline=_PutScanline_8bit_grayscale;
	                        break;
	                    case 2:
	                        _PutScanline=_PutScanline_16bit_grayscale;
	                        break;
	                    case 3:
	                        _PutScanline=_PutScanline_24bit_grayscale;
	                        break;
	                    case 4:
	                        _PutScanline=_PutScanline_32bit_grayscale;
	                        break;
	                    default:
	                        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	                        CLEAN_UP_FILE(inputfile);
	                        return JPEG_FAILURE;
	                    }
	            break;
	        case 3:
	            switch (draw_area->rgb.size)
	                    {
	                    case 1:
	                        _PutScanline=_PutScanline_8bit_color;
	                        break;
	                    case 2:
	                        _PutScanline=_PutScanline_16bit_color;
	                        break;
	                    case 3:
	                        _PutScanline=_PutScanline_24bit_color;
	                        break;
	                    case 4:
	                        _PutScanline=_PutScanline_32bit_color;
	                        break;
	                    default:
	                        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	                        CLEAN_UP_FILE(inputfile);
	                        return JPEG_FAILURE;
	                    }
	            break;
	        default:
	            jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
	            CLEAN_UP_FILE(inputfile);
	            return JPEG_FAILURE;
	        }

	    jpeg_dec_info.bufferinc0=cInfo.cInfo.output_components;

	/* Step 5: Start decompressor */

	    (void) jpeg_start_decompress((struct jpeg_decompress_struct*)&cInfo);

	    /* We can ignore the return value since suspension is not possible
	    * with the stdio data source.
	    */

	/* Step 6: while (scan lines remain to be read) */
	/*           gjpeg_read_scanlines(...); */

	    /* Here we use the library's state variable cinfo.output_scanline as the
	    * loop counter, so that we don't have to keep track ourselves.
	    */

	    jpeg_dec_info.finishline= jpeg_dec_info.endline=100000;
	    PutImageSlice(draw_area, (struct jpeg_decompress_struct*)&cInfo , &jpeg_dec_info, stop_flag);
	/* Step 7: Finish decompression */
	    jpeg_finish_decompress((struct jpeg_decompress_struct*)&cInfo);
	/* Step 8: Release JPEG decompression object */
	    jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);

	    CLEAN_UP_FILE(inputfile);
	    /* And we're done! */
	    if (*stop_flag)
	        return JPEG_DRAW_STOP;
	    else
	        return JPEG_SUCCESS;
}

U4  _GetImageJPEG(DRAW_IMG_INFO *draw_img, JPEG_IMG_INFO *jpeg_img_info)
{
    /* We use our private extension JPEG error handler.
    * Note that this struct must live as long as the main JPEG parameter
    * struct, to avoid dangling-pointer problems.
    */
    struct my_error_mgr jerr;
    jpeg_decompress_struct_ext cInfo;

    FILE    *inputfile = NULL;

    /* Step 1: allocate and initialize JPEG decompression object */
    /* We set up the normal JPEG error routines, then override error_exit. */
    cInfo.cInfo.err = jpeg_std_error(&jerr.pub);
    jerr.pub.error_exit = my_error_exit;
    /* Establish the setjmp return context for my_error_exit to use. */
    if (setjmp(jerr.setjmp_buffer)) {
        /* If we get here, the JPEG code has signaled an error.
        * We need to clean up the JPEG object, close the input file, and return.
        */
        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
        //CLEAN_UP_FILE(inputfile);
        return JPEG_FAILURE;
    }

    /* Step 0: initialize data source */
    if (draw_img->type & FILE_IMG)
    {
        inputfile=fopen((char*)draw_img->datap,"rb");
        if (inputfile==NULL)
            return JPEG_FAILURE;
	}
    else
    {
	    inputfile=NULL;
    }

    /* Now we can initialize the JPEG decompression object. */
    jpeg_create_decompress((struct jpeg_decompress_struct*)&cInfo);
    /* Step 1a: Initialize the EXIF reader */
    gjpeg_exif_init((struct jpeg_decompress_struct*)&cInfo);
    /* Step 2: specify data source (eg, a file) */
    jpeg_mem_src( (struct jpeg_decompress_struct*)&cInfo, draw_img->datap, draw_img->datasize);

    /* Step 3: read file parameters with gjpeg_read_header() */
    jpeg_read_header((struct jpeg_decompress_struct*)&cInfo, TRUE);

    if (draw_img->type & IMG_TYP_THNMB)
    {
        if ((cInfo.EXIF_Info.SawWhat &
               ((EXIF_SAW_COMPRESSION | EXIF_SAW_JPEGIFOFFSET | EXIF_SAW_JPEGIFBYTECOUNT | EXIF_SAW_ERROR)))!=
                (EXIF_SAW_COMPRESSION | EXIF_SAW_JPEGIFOFFSET | EXIF_SAW_JPEGIFBYTECOUNT))
            ERREXIT((struct jpeg_decompress_struct*)&cInfo,0);

        if (cInfo.EXIF_Info.Compression!=6)
            ERREXIT((struct jpeg_decompress_struct*)&cInfo,0);

        jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);
        /* Now we can initialize the JPEG decompression object. */
        jpeg_create_decompress((struct jpeg_decompress_struct*)&cInfo);
        /* Step 2: specify data source (eg, a file) */
        jpeg_mem_src( (struct jpeg_decompress_struct*)&cInfo, draw_img->datap, draw_img->datasize);
        /* Step 3: read file parameters with gjpeg_read_header() */
        jpeg_read_header((struct jpeg_decompress_struct*)&cInfo, TRUE);
    }

    /* Step 4: set parameters for decompression */
    /* Calculate output image dimensions so we can allocate space */
    jpeg_calc_output_dimensions((struct jpeg_decompress_struct*)&cInfo);
    /* Step 5: Fill in the information structure */
    jpeg_img_info->width=cInfo.cInfo.output_width;
    jpeg_img_info->height=cInfo.cInfo.output_height;
    jpeg_img_info->orientation=cInfo.EXIF_Info.Orientation;
	memcpy(jpeg_img_info->datetime, cInfo.EXIF_Info.Datetime, 20);
    /* Step 6: Release JPEG decompression object */
    /* This is an important step since it will release a good deal of memory. */
    jpeg_destroy_decompress((struct jpeg_decompress_struct*)&cInfo);

    CLEAN_UP_FILE(inputfile);
    /* And we're done! */
    return JPEG_SUCCESS;
}
